package ga.examples.quadratic;

import ga.core.goperators.ProbabilityOp;

import java.util.logging.Logger;

public final class TestProbabilities {

  // the logger for this class
  private static final Logger LOGGER = Logger.getLogger(TestProbabilities.class
      .getName());

  private TestProbabilities() {
  }

  public static void main(final String[] args) {
    final ProbabilityOp op = new QuadraticOnePointCrossoverOp(1);

    int j = 0;

    int i;

    for (i = 0; i < 1000000; i++) {
      if (op.doOperate()) {
        j++;
      }
    }

    LOGGER.info(j + " hits of " + i);
    LOGGER.info("p=" + (j / (double) i));
  }
}
